<?php


 /* Calling a PHP Function */
if(isset($_GET['reset_Password'])){
reset_Password();
}




 /* Main PHP Function */
 function reset_Password() 	{

	header('Content-type: application/json');
	require_once($_SERVER['DOCUMENT_ROOT'] . '/z_config/config.php');

 
	$response = array();

	if ($_POST) {
		
		$first_password = $_POST['first_password'];	
		$confirm_password = $_POST['confirm_password'];	
		$tokenValue = $_POST['tokenValue'];	
				
		$reg_date = date('d.m.Y', time());
		$lst_update_timestamp = date('d.m.Y', time());
		
		$active_date = date('Y-m-d');
		$active_time = date('H:i:s');		
		$active_timestamp = date('Y-m-d H:i:s', time());

		//error_log('active_date:  ---  ' . $active_date);
		//error_log('active_time:  ---  ' . $active_time);		
		//error_log('active_timestamp:  ---  ' . $active_timestamp);	
		//error_log('lst_update_timestamp:  ---  ' . $lst_update_timestamp);
		//exit();	



			// if (new DateTime() > new DateTime("2025-01-14 2:36:00")) {
				// # current time is greater than 2010-05-15 16:00:00
				// # in other words, 2010-05-15 16:00:00 has passed
				// error_log('DTP:  ---  has passed');
			// }
			//exit();




				 
				
			//check if token is valid/correct +++++++++++ users_activation	
			$stmt1 = $dbcon->prepare("SELECT id, status, email, member_uid, expiry_date FROM users_pass_reset_request WHERE token_key =?");
			$stmt1->execute(array($tokenValue));
			while($row = $stmt1->fetch(PDO::FETCH_ASSOC)) {				
				$db_itm_id = $row['id']; 
				$db_itm_status = $row['status']; 
				$db_itm_email = $row['email']; 
				$db_itm_member_uid = $row['member_uid']; 
				$db_itm_expiry_date = $row['expiry_date']; 
						}
				//1. checking if token is valid/correct		
				if ( $db_itm_id < 1 ) 
				{			
					//error_log('invalid_token' . $tokenValue);
					
					$response['status'] = 'invalid_token'; 
					$response['message'] = 'Supplied token is invalid.';
					echo json_encode($response);
					exit();						
					}  	
				//2. checking if password reset link is active	
				if ( $db_itm_status == 1 ) 
				{			
					//error_log('activation already done' . $tokenValue);
					
					$response['status'] = 'link_used';
					$response['message'] = 'Password reset link already used.';
					echo json_encode($response);
					exit();						
					}  
							
				//2B. checking if password link is within 24 hours range	
				if (new DateTime() > new DateTime($db_itm_expiry_date)) {
					# current time is greater than 2010-05-15 16:00:00
					# in other words, 2010-05-15 16:00:00 has passed
					//error_log('DTP:  ---  DateTime has passed');
					
					$response['status'] = 'link_expired';
					$response['message'] = 'Password reset link time frame is expired.';
					echo json_encode($response);
					exit();					
				
				}
			
		
				//3. password match checking
				if(strcmp($first_password, $confirm_password) !== 0){				
					//error_log('password_mismatch' . $first_password);
					$response['status'] = 'password_mismatch';
					$response['message'] = 'The password does not match.';
					echo json_encode($response);
					exit();
				}
	
				
				
				//4. hashing password	
				$hashed_password = md5($first_password);
				
				//5. update user account with new password
					$queryB = "UPDATE users SET pass = :hashed_password WHERE name = :db_itm_email";
						$stmtB = $dbcon->prepare( $queryB );
						$stmtB->bindParam(':hashed_password', $hashed_password);
						$stmtB->bindParam(':db_itm_email', $db_itm_email);
						//$stmtB->execute();								
						if ( $stmtB->execute() ) {								
			 	
									
								//************************************	
								//************************************	
								//************************************	
								//insert into users log table
								$a_module = 'User'; $a_action = 'Password reset'; $a_details = 'User password reset successfully';
								$query = "INSERT INTO users_actions_log ( a_date, a_time, a_uid, a_uname, a_module, a_action, a_details ) VALUES ( :a_date, :a_time, :a_uid, :a_uname, :a_module, :a_action, :a_details )";
									$stmt = $dbcon->prepare( $query );		
									$stmt->bindParam(':a_date', $active_date) ;
									$stmt->bindParam(':a_time', $active_time) ;						
									$stmt->bindParam(':a_uid', $db_itm_member_uid) ;	
									$stmt->bindParam(':a_uname', $db_itm_email) ;					
									$stmt->bindParam(':a_module', $a_module) ;						
									$stmt->bindParam(':a_action', $a_action) ;	
									$stmt->bindParam(':a_details', $a_details) ;							
									$stmt->execute();	
								//************************************	
								//************************************	
								//************************************	

								//update users_pass_reset_request table
								$queryC = "UPDATE users_pass_reset_request SET status = 1 WHERE id = :db_itm_id";
									$stmtC = $dbcon->prepare( $queryC );
									$stmtC->bindParam(':db_itm_id', $db_itm_id);
									$stmtC->execute();	
									


						$response['status'] = 'success';
						$response['message'] = 'Account password reset sucessfully.';	
							
					} else {
						
						$response['status'] = 'error'; // could not register
						$response['message'] = 'An error occured, contact EHCON-Technical.';
					}			
			
	}
		
		echo json_encode($response);

}


/* Send debug code to the Javascript console */ 
function debug_to_console($data) {
    if(is_array($data) || is_object($data))
	{
		echo("<script>console.log('PHP Debug: ".json_encode($data)."');</script>");
	} else {
		echo("<script>console.log('PHP Debug: ".$data."');</script>");
	}
}



